<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DetailDaily extends Model
{
    use HasFactory;
    protected $table = 'detail_dailies';

    protected $fillable = [
        'dailies_id',
        'unit_id',
        'form_item_id',
        'status_id',
        'note',
    ];

    /**
     * Relasi ke daily
     */
    public function Dailies()
    {
        return $this->belongsTo(Daily::class, 'dailies_id');
    }
    
    /**
     * Relasi ke Form item
     */
    public function formItem()
    {
        return $this->belongsTo(FormItem::class, 'form_item_id');
    }

    /**
     * Relasi ke unit
     */
    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id');
    }

    /**
     * Relasi ke status
     */
    public function status()
    {
        return $this->belongsTo(Status::class, 'status_id');
    }
}