<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use PermissionHelper;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Str;

class RoleAkses
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    // public function handle(Request $request, Closure $next): Response
    // {

    //     // dd($actions);
    //     $allActions = PermissionHelper::getPermissions();
    //     $request->attributes->set('allowed_actions', $allActions);

    //     $currentUrl = $request->route()->uri();
    //     $currentMethod = $request->method();
    //     $segments = explode('/', $currentUrl);
    //     $firstSegment = $segments[0] ?? 'model';
    //     $formattedUrl = preg_replace('/\{[^}]+\}/', '{' . $firstSegment . '}', $currentUrl);
    //     if (!in_array($formattedUrl, $allActions[$currentMethod] ?? [])) {
    //         abort(403, 'Akses tidak diizinkan');
    //     }

    //     return $next($request);
    // }
    public function handle(Request $request, Closure $next): Response
    {
        $allActions = PermissionHelper::getPermissions();
        $request->attributes->set('allowed_actions', $allActions);

        $currentUrl = $request->route()->uri();
        $currentMethod = $request->method();
        $vendorPrefix = config('app.prefix'); // misal vendor1
        if (Str::startsWith($currentUrl, $vendorPrefix . '/')) {
            $currentUrl = substr($currentUrl, strlen($vendorPrefix) + 1);
        }
        $segments = explode('/', $currentUrl);
        $normalizedUrl = implode('/', array_map(
            fn($seg) =>
            preg_match('/^{.*}$/', $seg)
            ? '{' . Str::singular(Str::replace('-', '_', $segments[0])) . '}'
            : $seg,
            $segments = explode('/', $currentUrl)
        ));

        // dd($allActions[$currentMethod]);
        $allowedUrls = array_column($allActions[$currentMethod] ?? [], 'url');
        if (!in_array($normalizedUrl, $allowedUrls)) {
            abort(403, 'Akses tidak diizinkan');
        }



        return $next($request);
    }


}
