<?php

namespace App\Http\Controllers;

use App\Interfaces\ShiftRepositoryInterface;
use Illuminate\Http\Request;
use PermissionHelper;
use Yajra\DataTables\Facades\DataTables;

class ShiftController extends Controller
{
    protected $shift;

    public function __construct(ShiftRepositoryInterface $shift)
    {
        $this->shift = $shift;
    }

    public function index()
    {
        $canCreate = PermissionHelper::hasPermission("shift")->create;
        $option = request()->option;
        $shift = $this->shift->datatable();
        if (request()->ajax()) {
            return $this->datatable($shift);
        }
        return view("master-data.shift.index", compact("shift", "canCreate"));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:20',
        ]);

        $this->shift->create(request()->all());

        return response()->json(['message' => 'shift berhasil ditambahkan.']);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:20',

        ]);

        $this->shift->update($id, [
            "name" => $request->name
        ]);

        return response()->json(['message' => 'shift berhasil diupdate.']);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {

        $this->shift->delete($id);
        return response()->json(data: ['message' => 'shift berhasil dihapus.']);
    }

    public function datatable($data)
    {
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function ($row) {
                $canEdit = PermissionHelper::hasPermission("shift")->update;
                $canDelete = PermissionHelper::hasPermission("shift")->delete;
                if (!$canEdit && !$canDelete) {
                    return "<span class='text-muted fst-italic'>Only View</span>";
                }
                $actionBtn = "<div class='d-flex gap-2'>";
                $actionBtn .= $canEdit && request()->option == "active" ?
                    '<a href="javascript:void(0)"
                                data-id="' . $row->id . '"
                                data-name="' . $row->name . '"
                                class="edit btn btn-warning btn-sm"><i class="fa fa-pencil"></i></a>' : "";

                $actionBtn .= $canDelete ? '<a href="javascript:void(0)"
                                data-id="' . $row->id . '"
                                class="delete btn btn-danger btn-sm"><i class="fa fa-trash"/></i></a>' : "";

                $actionBtn .= "</div>";
                return $actionBtn;
            })
            ->rawColumns(['action'])
            ->make(true);
    }
}