<?php

namespace App\Http\Controllers;

use App\Interfaces\ActionRoleRepositoryInterface;
use App\Interfaces\FormRepositoryInterface;
use App\Interfaces\RoleRepositoryInterface;
use App\Interfaces\StatusRepositoryInterface;
use App\Interfaces\TypeunitRepositoryInterface;
use App\Models\Action;
use App\Models\FormSection;
use App\Models\Status;
use Illuminate\Http\Request;
use PermissionHelper;
use Yajra\DataTables\Facades\DataTables;

class ChecklistSectionController extends Controller
{
    private $status;

    public function __construct(
        StatusRepositoryInterface $StatusRepositoryInterface,
    ) {
        $this->status = $StatusRepositoryInterface;
    }


    public function store(Request $request)
    {
        $request->validate([
            'name' => [
                'required',
                'string',
                function ($attribute, $value, $fail) {
                    if (str_word_count($value) > 25) {
                        $fail('Kolom ' . $attribute . ' maksimal 25 kata.');
                    }
                },
            ],

            'form_id' => 'required',
        ]);

        FormSection::create([
            "name" => $request->name,
            "form_id" => $request->form_id,
        ]);

        return response()->json(['message' => 'Checklist section berhasil ditambahkan.']);
    }

    /**
     * Display the specified resource.
     */


    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => [
                'required',
                'string',
                function ($attribute, $value, $fail) {
                    if (str_word_count($value) > 25) {
                        $fail('Kolom ' . $attribute . ' maksimal 25 kata.');
                    }
                },
            ],

            'form_id' => 'required',
        ]);

        FormSection::findOrFail($id)->update([
            "name" => $request->name,
            "form_id" => $request->form_id,
        ]);

        return response()->json(['message' => 'Checklist section berhasil diupdate.']);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {

        FormSection::find($id)->delete();
        return response()->json(data: ['message' => 'Checklist section berhasil dihapus.']);
    }


}
