<?php

namespace App\Http\Controllers;

use App\Interfaces\UserRepositoryInterface;
use Illuminate\Http\Request;
use PermissionHelper;
use Yajra\DataTables\DataTables;

class ApproveController extends Controller
{

    protected $userRepository;

    public function __construct(UserRepositoryInterface $userRepository)
    {
        $this->userRepository = $userRepository;
    }
    public function index()
    {
        $users = $this->userRepository->datatableApprove();
        if (request()->ajax()) {
            return $this->datatable($users);
        }
        return view("master-data.approve.index");
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, int $id)
    {
        $user = $this->userRepository->find($id);
        if (!$user) {
            return response()->json(['message' =>"User tidak ditemukan."]);
        }

        $approve = $request->approve == 'setuju' ? 1 : 0;

        $data = [
            'approve' => $approve
        ]; 

        $user->update($data);

        return response()->json([
            'message' => 'User berhasil diupdate',
        ]);
    }

    public function datatable($data)
    {
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function ($row) {
                $canEdit = PermissionHelper::hasPermission("aprrove")->update;
                $actionBtn = "<div class='d-flex  gap-1'>";
                if ($canEdit) {
                    if (is_null($row->approve)) {
                        $actionBtn .= '
                            <button type="button"
                                class="btn btn-sm btn-warning btn-approve"
                                data-id="' . $row->id . '">
                                Approve
                            </button>';
                    } elseif ($row->approve == 0) {
                        $actionBtn .= '
                            <span class="badge bg-danger text-white">
                                Status Akun Sudah Ditolak
                            </span>';
                    }
                }
                $actionBtn .= "</div>";

                return $actionBtn;
            })

            ->addColumn("role", function ($row) {
                return $row->role->role;
            })
            ->addColumn("sites", function ($row) {
                return $row->location->name;
            })
            ->rawColumns(['action'])
            ->make(true);
    }
}