<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Interfaces\LocationRepositoryInterface;
use App\Repositories\ApiRpositories\MasterRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MasterController extends Controller
{
    protected $masterRepository;
    protected $locationRepository;

    public function __construct(MasterRepository $masterRepository, LocationRepositoryInterface $locationRepo)
    {
        $this->masterRepository = $masterRepository;
        $this->locationRepository = $locationRepo;
    }

    public function getAllUser(Request $request)
    {
        $search = $request->query('search');

        $data = $this->masterRepository->getAllUser($search);

        return response()->json([
            'status' => 'success',
            'data' => $data
        ]);
    }
    public function getAllLocation(Request $request)
    {
        $search = $request->query('search');

        $data = $this->locationRepository->datatable()->where("name", "LIKE", "%$search%")->select("id", "name")->get();

        return response()->json([
            'status' => 'success',
            'data' => $data
        ]);
    }


    public function getAllUnit(Request $request)
    {

        try {
            $search = $request->query('search');
            $user = Auth::guard('sanctum')->user();

            $data = $this->masterRepository->getAllUnit($search, $user);

            return response()->json([
                'status' => 'success',
                'data' => $data
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => 'error',
                "error" => $th->getMessage()
            ], 500);
        }
    }


    public function getAllForm(Request $request)
    {
        $search = $request->query('search');
        $data = $this->masterRepository->getAllForm($search);

        return response()->json([
            'status' => 'success',
            'data' => $data
        ]);
    }

    public function getAllAproval(Request $request)
    {
        $search = $request->query('search');

        $data = $this->masterRepository->getAllAproval($search);

        return response()->json([
            'status' => 'success',
            'data' => $data
        ]);
    }

    public function updateApprove(Request $request)
    {
        $request->validate([
            'id' => 'required|exists:users,id',
            'approve' => 'required|in:0,1',
        ]);

        $user = $this->masterRepository->updateApproveStatus(
            $request->id,
            $request->approve
        );

        if (!$user) {
            return response()->json([
                'status' => 'error',
                'message' => 'User tidak ditemukan'
            ], 404);
        }

        $statusText = $request->approve == 1 ? 'disetujui' : 'ditolak';

        return response()->json([
            'status' => 'success',
            'message' => "Akun berhasil {$statusText}",
            'data' => [
                'id' => $user->id,
                'name' => $user->name,
                'approve' => $user->approve
            ]
        ], 200);
    }

}
