<?php

namespace App\Http\Controllers;

use App\Interfaces\ActionRepositoryInterface;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class ActionController extends Controller
{
    private $action;

    public function __construct(ActionRepositoryInterface $action)
    {
        $this->action = $action;
    }

    public function index()
    {
        if (request()->ajax()) {
            return $this->datatable($this->action->all());
        }
        return view("master-data.action.index");
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:100',
            'base_url' => 'required|string|max:100',
            'parent_menu' => 'required|string|max:100',

        ]);
        $data = [
            "name" => $request->name,
            "base_url" => $request->base_url,
            "parent_menu" => $request->parent_menu,
        ];

        $this->action->create($data);
        return response()->json(['message' => 'action berhasil ditambahkan.']);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'name' => 'required|string|max:100',
            'parent_menu' => 'required|string|max:100',
            'base_url' => 'required|string|max:100',
        ]);
        $data = [
            "name" => $request->name,
            "base_url" => $request->base_url,
            "parent_menu" => $request->parent_menu,
        ];
        $this->action->update($id, $data);

        // Response JSON untuk AJAX
        return response()->json(['message' => 'action berhasil diupdate.']);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $this->action->delete($id);
        return response()->json(data: ['message' => 'action berhasil dihapus.']);
    }

    public function datatable($data)
    {
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function ($row) {
                $actionBtn = "<div class='d-flex gap-2'>";
                $actionBtn .= '<a href="javascript:void(0)" data-id="' . $row->id . '"
                data-name="' . $row->name . '"
                data-base_url="' . $row->base_url . '"
                data-parent_name="' . $row->parent_menu . '"
                class="edit btn btn-warning btn-sm"><i class="fa fa-pencil"></i></a>';
                $actionBtn .= '<a href="javascript:void(0)" data-id="' . $row->id . '" class="delete btn btn-danger btn-sm"><i class="fa fa-trash"/></i></a>';
                $actionBtn .= "</div>";
                return $actionBtn;
            })
            ->rawColumns(['action'])
            ->make(true);
    }
}
